% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_path_script.R
\name{tar_path_script}
\alias{tar_path_script}
\title{Current target script path}
\usage{
tar_path_script()
}
\value{
Character, file path to the target script
of the pipeline currently running.
If called outside of the pipeline currently running,
\code{tar_path_script()} returns \code{tar_config_get("script")}.
}
\description{
Identify the file path to the target script
of the pipeline currently running.
}
\examples{
tar_path_script()
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
script <- tempfile()
tar_script(tar_target(x, tar_path_script()), script = script, ask = FALSE)
tar_make(script = script)
tar_read(x)
})
}
}
\seealso{
Other utilities: 
\code{\link{tar_active}()},
\code{\link{tar_backoff}()},
\code{\link{tar_call}()},
\code{\link{tar_cancel}()},
\code{\link{tar_definition}()},
\code{\link{tar_described_as}()},
\code{\link{tar_envir}()},
\code{\link{tar_format_get}()},
\code{\link{tar_group}()},
\code{\link{tar_name}()},
\code{\link{tar_path}()},
\code{\link{tar_path_script_support}()},
\code{\link{tar_path_store}()},
\code{\link{tar_path_target}()},
\code{\link{tar_source}()},
\code{\link{tar_store}()}
}
\concept{utilities}
