% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_deduplicate.R
\name{tar_deduplicate}
\alias{tar_deduplicate}
\title{Deduplicate meta and progress databases.}
\usage{
tar_deduplicate(meta = TRUE, progress = TRUE)
}
\arguments{
\item{meta}{Logical, whether to deduplicate the meta database file
at \verb{_targets/meta/meta}.}

\item{progress}{Logical, whether to deduplicate the progress database file
at \verb{_targets/meta/progress}.}
}
\value{
Nothing.
}
\description{
Remove duplicated entries in the meta and progress
databases in order to lighten storage. These databases are located
in the \verb{_targets/meta/meta} and \verb{_targets/meta/progress} files,
and the \verb{_targets} data store lives in the current working directory.
No essential data is removed, so
this is simply a form of garbage collection.
}
\examples{
if (identical(Sys.getenv("TARGETS_LONG_EXAMPLES"), "true")) {
tar_dir({ # Write all files to a temporary directory.
tar_script(list(tar_target(x, 1 + 1)))
tar_make()
tar_make()
tar_deduplicate() # Compare the file _targets/meta/meta before and after.
})
}
}
