% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_format_nanoparquet.R
\name{tar_format_nanoparquet}
\alias{tar_format_nanoparquet}
\title{Nanoparquet format}
\usage{
tar_format_nanoparquet(compression = "snappy", class = "tbl")
}
\arguments{
\item{compression}{Character string, compression type for saving the
data. See the \code{compression} argument of \code{\link[nanoparquet:write_parquet]{nanoparquet::write_parquet()}}
for details.}

\item{class}{Character vector with the data frame subclasses to assign.
See the \code{class} argument of \code{\link[nanoparquet:parquet_options]{nanoparquet::parquet_options()}} for details.}
}
\value{
A \code{\link[targets:tar_format]{targets::tar_format()}} storage format specification string
that can be directly supplied to the \code{format} argument of
\code{\link[targets:tar_target]{targets::tar_target()}} or \code{\link[targets:tar_option_set]{targets::tar_option_set()}}.
}
\description{
Nanoparquet storage format for data frames.
Uses \code{\link[nanoparquet:read_parquet]{nanoparquet::read_parquet()}} and \code{\link[nanoparquet:write_parquet]{nanoparquet::write_parquet()}}
to read and write data frames returned by targets in a pipeline.
Note: attributes such as \code{dplyr} row groupings and \code{posterior}
draws info are dropped during the writing process.
}
\examples{
if (identical(Sys.getenv("TAR_LONG_EXAMPLES"), "true")) {
targets::tar_dir({ # tar_dir() runs code from a temporary directory.
targets::tar_script({
  library(targets)
  libary(tarchetypes)
  list(
    tar_target(
      name = data,
      command = data.frame(x = 1),
      format = tar_format_nanoparquet()
    )
  )
})
tar_make()
tar_read(data)
})
}
}
\keyword{formats}
\keyword{storage}
