% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_tapnet.R
\name{predict_tapnet}
\alias{predict_tapnet}
\title{Predict from fitted tapnet to new data}
\usage{
predict_tapnet(fit, abuns, tapnet = NULL)
}
\arguments{
\item{fit}{results of applying fit_tapnet to the tapnet object;}

\item{abuns}{named list of two entries ("low" and "high"), containing a species-named vector of abundances of the new network}

\item{tapnet}{optional name of a tapnet object containing traits, phylogeny etc.; these are not stored in \option{fit}, but rather it is assumed that a tapnet object with the name stored in \option{fit} is available in the global environment. That may not be the case, e.g. when simulating networks. In this case, \option{tapnet} provides the required tapnet-object.}
}
\value{
A matrix of predicted interaction probabilities, summing to 1. This would need to be multiplied by the total number of interactions in the new network to be comparable to the observations.
}
\description{
Function allows direct use of data prepared for tapnet analysis by other statistical methods, e.g. regression approaches
}
\details{
The fitted tapnet object contains the estimated parameters, describing how traits, abundance and phylogeny play together to produce the network(s) used for fitting. This information is now used to predict interaction probabilities for a new network. Accordingly, we need to know this new network's species abundances (an input to the function), PEMs and traits. The latter are computed based on the information contained in the tapnet object (which is linked in by attribute reference). For new species, their PEMs are computed and the network is simulated, using \code{\link{simnetfromtap}}, for the information provided.
}
\examples{
\donttest{
  data(Tinoco)
  tap <- make_tapnet(tree_low = plant_tree, tree_high = humm_tree, networks = networks[1:2], 
         traits_low = plant_traits, traits_high = humm_traits, npems_lat = 4)
  fit <- fit_tapnet(tap) # uses two networks for fitting!
  gof_tapnet(fit)
  # predict to omitted forest network's abundances:
  pred1 <- predict_tapnet(fit, abuns=list("low"=plant_abun[[3]], "high"=humm_abun[[3]] )) 
  cor(as.vector(pred1*sum(networks[[3]])), as.vector(networks[[3]])) 
}

}
\references{
Benadi et al. in prep
}
\author{
Ruth Stephan, Gita Benadi and Carsten Dormann <carsten.dormann@biom.uni-freiburg.de>
}
