% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panel.qqmathci.R
\name{panel.qqmathci}
\alias{panel.qqmathci}
\title{Q-Q Diagram Confidence Intervals Panels}
\usage{
panel.qqmathci(x, y = x, distribution = qnorm, probs = c(0.25, 0.75),
  qtype = 7, groups = NULL, ci = 0.95, alpha = 0.25,
  col = trellis.par.get("plot.line")$col, ..., col.line)
}
\arguments{
\item{x}{ The original sample, possibly reduced to a fewer number of
    quantiles, as determined by the \code{f.value} argument to
    \code{qqmath}
  }

\item{y}{
    an alias for \code{x} for backwards compatibility
  }

\item{distribution}{
    quantile function for reference theoretical distribution.
  }

\item{probs}{
    numeric vector of length two, representing probabilities.
    Corresponding quantile pairs define the line drawn.
  }

\item{qtype}{
    the \code{type} of quantile computation used in
    \code{\link{quantile}}
  }

\item{groups}{
    optional grouping variable.  If non-null, a line will be drawn for
    each group.
  }

\item{ci}{Confidence level}

\item{alpha}{Alpha level for the color fill}

\item{col}{Color fill for the confidence bands.}

\item{\dots}{Arguments passed to \code{\link[lattice:panel.superpose]{lattice::panel.superpose()}} and
\code{\link[lattice:panel.polygon]{lattice::panel.polygon()}}}

\item{col.line}{Color fill for the confidence bands. Is used internally
by \code{\link[lattice:panel.superpose]{lattice::panel.superpose()}} and should generally not be changed.}
}
\value{
Augments a trellis plot panel, such as that
created by \code{\link[lattice:qqmath]{lattice::qqmath()}}, with confidence levels.
}
\description{
Panel function to go along with \code{\link[lattice:qqmath]{lattice::qqmath()}} and
\code{\link[lattice:panel.qqmathline]{lattice::panel.qqmathline()}}. Adds filled confidence bands to the Q-Q-plot.
}
\details{
The function tries to figure out the density function counterpart to
that provided in the argument \code{distribution} by regular expressions.
}
\examples{
qqmath(~ height | voice.part, aspect = "xy", data = singer,
       prepanel = prepanel.qqmathline,
       panel = function(x, ...) {
         panel.qqmathci(x, ...)
         panel.qqmathline(x, ...)
         panel.qqmath(x, ...)
       })
}
\seealso{
\code{\link[lattice:panel.qqmathline]{lattice::panel.qqmathline()}}, \code{\link[lattice:qqmath]{lattice::qqmath()}}, and
\code{\link[lattice:panel.qqmath]{lattice::panel.qqmath()}}.
}
\author{
Johan Larsson.
}
