% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmt_class.R
\name{fmt_get_color_code}
\alias{fmt_get_color_code}
\title{Get HTML Color Code of a fmt vector}
\usage{
fmt_get_color_code(x, type = "text", theme = "light", html_24_bit = NULL)
}
\arguments{
\item{x}{The fmt vector to get the html color codes from.}

\item{type}{The style type in \code{set_color_style} and \code{get_color_style},
\code{"text"} to color the text, \code{"bg"} to color the background.}

\item{theme}{For \code{set_color_style} and \code{get_color_style}, is your console
or html table background \code{"light"} or \code{"dark"} ? Default to RStudio theme.}

\item{html_24_bit}{Should specific 24bits colors palettes be used for html tables ?
With light themes only. Default to \code{getOption("tabxplor.color_html_24_bit")}}
}
\value{
A character vector with html color codes, of the length of the initial vector.
}
\description{
Get HTML Color Code of a fmt vector
}
\examples{
\donttest{
tabs <- tab(forcats::gss_cat, race, marital, pct = "row", color = "diff")
dplyr::mutate(tabs, across(where(is_fmt), fmt_get_color_code))
}
}
