% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/diversity_alpha.R
\docType{methods}
\name{index_ice}
\alias{index_ice}
\alias{index_ice-method}
\alias{index_ice,matrix-method}
\title{Incidence-based Coverage Estimator}
\usage{
index_ice(x, ...)

\S4method{index_ice}{matrix}(x, k = 10, ...)
}
\arguments{
\item{x}{A \eqn{m \times p}{m x p} \code{\link{matrix}} of presence/absence data
(incidence).}

\item{...}{Currently not used.}

\item{k}{A length-one \code{\link{numeric}} vector giving the threshold between
rare/infrequent and abundant/frequent species.}
}
\value{
A \code{\link{numeric}} vector.
}
\description{
Incidence-based Coverage Estimator
}
\references{
Chao, A. & Chiu, C.-H. (2016). Species Richness: Estimation and Comparison.
\emph{In} Balakrishnan, N., Colton, T., Everitt, B., Piegorsch, B., Ruggeri,
F. & Teugels, J. L. (Eds.), \emph{Wiley StatsRef: Statistics Reference Online}.
Chichester, UK: John Wiley & Sons, Ltd., 1-26.
\doi{10.1002/9781118445112.stat03432.pub2}
}
\seealso{
Other alpha diversity measures: 
\code{\link{index_ace}()},
\code{\link{index_baxter}()},
\code{\link{index_berger}()},
\code{\link{index_boone}()},
\code{\link{index_brillouin}()},
\code{\link{index_chao1}()},
\code{\link{index_chao2}()},
\code{\link{index_hurlbert}()},
\code{\link{index_margalef}()},
\code{\link{index_mcintosh}()},
\code{\link{index_menhinick}()},
\code{\link{index_shannon}()},
\code{\link{index_simpson}()},
\code{\link{index_squares}()}
}
\author{
N. Frerebeau
}
\concept{alpha diversity measures}
