% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/trakt.related.R
\name{trakt.movies.related}
\alias{trakt.movies.related}
\title{Search for related movies}
\usage{
trakt.movies.related(target, extended = "min")
}
\arguments{
\item{target}{The \code{id} of the movie requested. Either the \code{slug}
(e.g. \code{"tron-legacy-2010"}), \code{trakt id} or \code{IMDb id}. If multiple \code{target}s are
provided, the results will be \code{rbind}ed together and a \code{source} column as appended,
containing the provided \code{id} of the input.}

\item{extended}{Whether extended info should be provided.
Defaults to \code{"min"}, can either be \code{"min"} or \code{"full"}.}
}
\value{
A \code{data.frame} containing search results
}
\description{
\code{trakt.movies.related} returns movies related to the input movie.
}
\details{
Receive a set of movies that are related to a specific movie.
}
\note{
See \href{http://docs.trakt.apiary.io/reference/movies/related/get-related-movies}{the trakt API docs for further info}
}
\examples{
\dontrun{
get_trakt_credentials() # Set required API data/headers
related <- trakt.movies.related("tron-legacy-2010")
}
}
\seealso{
Other aggregated data: \code{\link{trakt.movies.popular}};
  \code{\link{trakt.movies.trending}};
  \code{\link{trakt.shows.popular}};
  \code{\link{trakt.shows.related}};
  \code{\link{trakt.shows.trending}}

Other movie data: \code{\link{trakt.movie.people}};
  \code{\link{trakt.movie.ratings}};
  \code{\link{trakt.movie.releases}};
  \code{\link{trakt.movie.summary}};
  \code{\link{trakt.movie.watching}};
  \code{\link{trakt.movies.popular}};
  \code{\link{trakt.movies.trending}};
  \code{\link{trakt.stats}}
}

