% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/trakt.people.R
\name{trakt.movie.people}
\alias{trakt.movie.people}
\title{Get the cast and crew of a movie}
\usage{
trakt.movie.people(target, extended = "min")
}
\arguments{
\item{target}{The \code{id} of the movie requested. Either the \code{slug}
(e.g. \code{"tron-legacy-2010"}), \code{trakt id} or \code{IMDb id}}

\item{extended}{Whether extended info should be provided.
Defaults to \code{"min"}, can either be \code{"min"} or \code{"full"}}
}
\value{
A \code{list} containing \code{data.frame}s for cast and crew.
}
\description{
\code{trakt.movie.people} pulls movie people data.
}
\details{
Returns all cast and crew for a movie, depending on how much data is available.
}
\note{
See \href{http://docs.trakt.apiary.io/#reference/movies/people/get-all-people-for-a-movie}{the trakt API docs for further info}
}
\examples{
\dontrun{
get_trakt_credentials() # Set required API data/headers
tron.people <- trakt.movie.people("tron-legacy-2010")
}
}
\seealso{
Other movie data: \code{\link{trakt.movie.ratings}};
  \code{\link{trakt.movie.releases}};
  \code{\link{trakt.movie.summary}};
  \code{\link{trakt.movie.watching}};
  \code{\link{trakt.movies.popular}};
  \code{\link{trakt.movies.related}};
  \code{\link{trakt.movies.trending}};
  \code{\link{trakt.stats}}

Other people data: \code{\link{trakt.people.movies}};
  \code{\link{trakt.people.shows}};
  \code{\link{trakt.people.summary}};
  \code{\link{trakt.show.people}}
}

