% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/api.R
\name{trakt.api.call}
\alias{trakt.api.call}
\title{Make an APIv2 call to any URL}
\usage{
trakt.api.call(url, headers = getOption("trakt.headers"),
  fromJSONify = TRUE, convert.datetime = TRUE)
}
\arguments{
\item{url}{APIv2 method. See \href{http://docs.trakt.apiary.io/}{the trakt API}.}

\item{headers}{HTTP headers to set. Must be result of \code{httr::add_headers}.
Default value is \code{getOption("trakt.headers")} set by \link[tRakt]{get_trakt_credentials}.}

\item{fromJSONify}{If \code{TRUE} (default), the API response will be converted to an object via
\code{jsonlite::fromJSON}}

\item{convert.datetime}{If \code{TRUE} (default), datetime variables are converted to
\code{POSIXct}. Requires \code{fromJSONify} to be \code{TRUE} as well.}
}
\value{
The content of the API response, \code{jsonlite::fromJSON}'d if requested.
}
\description{
\code{trakt.api.call} makes an APIv2 call to a specified URL
and returns the output \code{jsonlite::fromJSON}'d if requested.
}
\note{
This function is heavily used internally, so why not expose it to the user.
}
\examples{
\dontrun{
get_trakt_credentials() # Set required API data/headers
trakt.api.call("https://api-v2launch.trakt.tv/shows/breaking-bad?extended=min")
}
}
\seealso{
Other API-basics: \code{\link{get_trakt_credentials}};
  \code{\link{trakt.search.byid}};
  \code{\link{trakt.search}}
}

