% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/a_class-methods_helpers.R
\name{all_geog_constraint_income}
\alias{all_geog_constraint_income}
\title{Create individual income constraint list to a set of geographies}
\usage{
all_geog_constraint_income(obj, method = c("synthetic", "macro.table"))
}
\arguments{
\item{obj}{An object of class \code{"synthACS"}.}

\item{method}{One of \code{c("synthetic", "macro.table")}. Specifying \code{"synthetic"} indicates
that constraints are built by marginalizing the synthetic micro datasets. Specifying 
\code{"macro.table"} indicates that the constraints are build from the data in the base ACS tables.}
}
\description{
Create a new individual income constraint list to the mapping between a a set 
of macro datasets and a matching set of micro dataset (supplied as class 'synthACS').
}
\examples{
\dontrun{
 # assumes that obj of class 'synthACS' already exists in your environment
 i1 <- all_geog_constraint_income(obj, "synthetic")
 i2 <- all_geog_constraint_income(obj, "macro_table")
}
}
\seealso{
\code{\link{all_geogs_add_constraint}}
}
