/*
 * Decompiled with CFR 0.152.
 */
package sample;

import haplotype.SampleHapPairs;
import java.util.stream.IntStream;
import sample.RefHapSeg;

public class RefHapSegs {
    private final int[] segStart;
    private final int[] segEnd;
    private final SampleHapPairs refHapPairs;
    private final RefHapSeg[] refHapSegs;

    public RefHapSegs(SampleHapPairs sampleHapPairs, int[] nArray, int[] nArray2) {
        int n2 = sampleHapPairs.nMarkers();
        this.checkClusters(nArray, nArray2, n2);
        this.segStart = (int[])nArray.clone();
        this.segEnd = (int[])nArray2.clone();
        this.refHapPairs = sampleHapPairs;
        this.refHapSegs = (RefHapSeg[])IntStream.range(0, this.segStart.length).parallel().mapToObj(n -> new RefHapSeg(sampleHapPairs, nArray[n], nArray2[n])).toArray(RefHapSeg[]::new);
    }

    private void checkClusters(int[] nArray, int[] nArray2, int n) {
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("inconsistent data");
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= 0 && nArray[i] < nArray2[i] && nArray2[i] <= n) continue;
            throw new IllegalArgumentException("inconsistent data");
        }
    }

    public SampleHapPairs refHapPairs() {
        return this.refHapPairs;
    }

    public int nSeq(int n) {
        return this.refHapSegs[n].nSeq();
    }

    public int nMarkers(int n) {
        return this.refHapSegs[n].end() - this.refHapSegs[n].start();
    }

    public int seq(int n, int n2) {
        return this.refHapSegs[n].seq(n2);
    }

    public int allele(int n, int n2, int n3) {
        return this.refHapSegs[n].allele(n2, n3);
    }

    public int nSegs() {
        return this.segStart.length;
    }

    public int segStart(int n) {
        return this.segStart[n];
    }

    public int segEnd(int n) {
        return this.segEnd[n];
    }
}

