/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.ChromInterval;
import beagleutil.Samples;
import blbutil.Filter;
import blbutil.SampleFileIterator;
import haplotype.HapPair;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import vcf.BasicGL;
import vcf.Data;
import vcf.GL;
import vcf.Marker;
import vcf.Markers;
import vcf.VcfEmission;
import vcf.VcfEmissionIterator;
import vcf.VcfIterator;
import vcf.VcfRecord;
import vcf.VcfWindow;

public class NonRefData
implements Data {
    private final VcfWindow vcfWindow;
    private int window = 0;
    private Markers markers;
    private VcfEmission[] markerData;
    private GL gl;

    private NonRefData(VcfWindow vcfWindow) {
        this.vcfWindow = vcfWindow;
        this.markers = new Markers(new Marker[0]);
        this.markerData = new VcfEmission[0];
        this.gl = new BasicGL(vcfWindow.samples(), this.markerData);
    }

    public static Data gt(File file, Filter<String> filter, Filter<Marker> filter2, ChromInterval chromInterval, File file2, boolean bl) {
        SampleFileIterator<VcfRecord> sampleFileIterator = VcfIterator.filteredIterator(file, filter, filter2, chromInterval);
        SampleFileIterator<VcfEmission> sampleFileIterator2 = VcfEmissionIterator.gt(sampleFileIterator, file2, bl);
        return new NonRefData(new VcfWindow(sampleFileIterator2));
    }

    public static Data gl(File file, Filter<String> filter, Filter<Marker> filter2, ChromInterval chromInterval, File file2, float f) {
        SampleFileIterator<VcfRecord> sampleFileIterator = VcfIterator.filteredIterator(file, filter, filter2, chromInterval);
        SampleFileIterator<VcfEmission> sampleFileIterator2 = VcfEmissionIterator.gl(sampleFileIterator, file2, f);
        return new NonRefData(new VcfWindow(sampleFileIterator2));
    }

    public static Data gtgl(File file, File file2, boolean bl, float f, Filter<String> filter, Filter<Marker> filter2, ChromInterval chromInterval) {
        boolean bl2 = false;
        SampleFileIterator<VcfRecord> sampleFileIterator = VcfIterator.filteredIterator(file, filter, filter2, chromInterval);
        SampleFileIterator<VcfEmission> sampleFileIterator2 = VcfEmissionIterator.gtgl(sampleFileIterator, file2, bl, f, bl2);
        return new NonRefData(new VcfWindow(sampleFileIterator2));
    }

    @Override
    public boolean lastWindowOnChrom() {
        return this.vcfWindow.lastWindowOnChrom();
    }

    @Override
    public boolean canAdvanceWindow() {
        return this.vcfWindow.canAdvanceWindow();
    }

    @Override
    public void advanceWindow(int n, int n2) {
        this.markerData = this.vcfWindow.advanceWindow(n, n2);
        this.markers = NonRefData.extractMarkers(this.markerData);
        this.gl = new BasicGL(this.vcfWindow.samples(), this.markerData);
        ++this.window;
    }

    private static Markers extractMarkers(VcfEmission[] vcfEmissionArray) {
        Marker[] markerArray = new Marker[vcfEmissionArray.length];
        for (int i = 0; i < markerArray.length; ++i) {
            markerArray[i] = vcfEmissionArray[i].marker();
        }
        return new Markers(markerArray);
    }

    @Override
    public int window() {
        return this.window;
    }

    @Override
    public int overlap() {
        return this.vcfWindow.overlap();
    }

    @Override
    public int nonRefOverlap() {
        return this.vcfWindow.overlap();
    }

    @Override
    public int cumMarkerCnt() {
        return this.vcfWindow.cumMarkerCnt();
    }

    @Override
    public Markers markers() {
        return this.markers;
    }

    @Override
    public Markers nonRefMarkers() {
        return this.markers;
    }

    @Override
    public int nMarkers() {
        return this.markers.nMarkers();
    }

    @Override
    public int nNonRefMarkers() {
        return this.markers.nMarkers();
    }

    @Override
    public int markerIndex(int n) {
        if (n < 0 || n >= this.markers.nMarkers()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return n;
    }

    @Override
    public int nonRefMarkerIndex(int n) {
        if (n < 0 || n >= this.markers.nMarkers()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return n;
    }

    @Override
    public int nRefSamples() {
        return 0;
    }

    @Override
    public Samples refSamples() {
        return null;
    }

    @Override
    public int nNonRefSamples() {
        return this.vcfWindow.nSamples();
    }

    @Override
    public Samples nonRefSamples() {
        return this.vcfWindow.samples();
    }

    @Override
    public GL refEmissions() {
        return null;
    }

    @Override
    public GL nonRefEmissions() {
        return this.gl;
    }

    @Override
    public List<HapPair> restrictedRefHaps() {
        return new ArrayList<HapPair>();
    }

    @Override
    public List<HapPair> refHaps() {
        return new ArrayList<HapPair>();
    }

    @Override
    public void close() {
        this.vcfWindow.close();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("vcf.NonRefData");
        return stringBuilder.toString();
    }
}

