% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluation.R
\name{substituteParameters}
\alias{substituteParameters}
\title{Assign values to the parameters of a 'symbolicQspray'}
\usage{
substituteParameters(Qspray, values)
}
\arguments{
\item{Qspray}{a \code{symbolicQspray} object}

\item{values}{vector of values to be substituted to the parameters; these
values must be coercible to \code{bigq} numbers}
}
\value{
A \code{qspray} object.
}
\description{
Substitutes some values to the parameters of a
  \code{symbolicQspray} polynomial.
}
\examples{
library(symbolicQspray)
f <- function(a1, a2, X, Y) {
  (a1 + 2)*X^2*Y + (a2/(a1^2+a2))*X*Y
}
Qspray <- f(qlone(1), qlone(2), Qlone(1), Qlone(2))
a <- c(2, "2/3")
( qspray <- substituteParameters(Qspray, values = a) )
a <- gmp::as.bigq(a)
qspray == f(a[1], a[2], qlone(1), qlone(2)) ## should be TRUE
}
\seealso{
Use \code{\link{changeParameters}} to apply a transformation of the
  parameters. Use \code{\link{substituteVariables}} to substitute some
  values to the variables.
}
