% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queries.R
\name{hasPolynomialCoefficientsOnly}
\alias{hasPolynomialCoefficientsOnly}
\title{Whether the coefficients of a 'symbolicQspray' polynomially depend
  on its parameters}
\usage{
hasPolynomialCoefficientsOnly(Qspray)
}
\arguments{
\item{Qspray}{a \code{symbolicQspray} object}
}
\value{
A Boolean value. The coefficients of a \code{symbolicQspray}
  polynomial always are fractions of polynomials. This function checks
  whether they are polynomials.
}
\description{
Checks whether the dependence of the coefficients of a
  \code{symbolicQspray} polynomial on their parameters is polynomial.
}
\examples{
JP <- JacobiPolynomial(4)
hasPolynomialCoefficientsOnly(JP)
}
