% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/das.map.R
\name{das.map}
\alias{das.map}
\title{Map DAS}
\usage{
das.map(x, main, spp = NULL, spp.col = rainbow(length(spp), end = max(1,
  length(spp) - 2)/length(spp)), lat.range = NULL, lon.range = NULL,
  n.ticks = 5, spp.legend.loc = "topleft", effort.legend.loc = "topright")
}
\arguments{
\item{x}{filename of a DAS file or a \code{data.frame} from \code{\link{das.read}}.}

\item{main}{main title for plot.}

\item{spp}{vector of species codes to plot sightings of. If \code{NULL}, only effort will be shown.}

\item{spp.col}{vector of colors for each species.}

\item{lat.range,lon.range}{latitude and longitude range of map.}

\item{n.ticks}{number of desired tick marks for latitude and longitude.}

\item{spp.legend.loc,effort.legend.loc}{the location of the species and effort legends.
 Can be a single keyword as specified in \code{\link{legend}}, or a two-element numeric vector
 giving the x (longitude) and y (latitude) coordinates.}
}
\description{
Map sightings, effort, and beaufort from DAS file
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}

