% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svdvis.R
\name{svd.scree}
\alias{svd.scree}
\title{Scree plot}
\usage{
svd.scree(svd.obj, subr = NULL, maintitle = "Scree Plot",
  axis.title.x = "Singular Vectors",
  axis.title.y = "Percent Variance Explained")
}
\arguments{
\item{svd.obj}{A list, resulted from applying svd to a dataset, with \code{u}, \code{d}, and \code{v} corresponding to left singular vector, singular values, and right singular vectors, respectively. Alternatively, supply a vector of singular values, \code{d}.}

\item{subr}{An optional positive integer to display PVE corresponding to the first \code{subr} singular values.}

\item{maintitle}{A figure title (by default, "Scree Plot").}

\item{axis.title.x}{A title for x axis (by default, "Singular Vectors").}

\item{axis.title.y}{A title for y axis (by default, "Percent Variance Explained").}
}
\value{
\code{svd.scree} creates and draws a figure, which is a \code{ggplot2} when \code{subr=NULL} or a {gtable} object when \code{subr} is specified.
}
\description{
Creates a scree plot, where percentages of variance explained (PVE) by singular vectors are plotted.
Additional customizations can be done by adding \code{ggplot2} functions to the output.
}
\examples{
set.seed(1234)
dat = matrix(rnorm(1000), 100, 10)
svd.obj = svd(dat)
colnames(svd.obj$v) = paste0("V",1:10)
svd.scree(svd.obj)
}
\author{
Neo Christopher Chung \email{nchchung@gmail.com}
}

