#' Visualize singular value decompositions (SVD), principal component analysis (PCA), factor analysis (FA) and related methods.
#'
#' \tabular{ll}{
#' Package: \tab svdvis\cr
#' Type: \tab Package\cr
#' Version: \tab 1\cr
#' License: \tab GPL-2\cr
#' Depends: \tab ggplot2, GGally, gridExtra, scales, reshape2, RColorBrewer, grDevices\cr
#' }
#'
#' Providing convenient visualization functions for paired scatterplots, heat maps, parallel coordinates, and radial coordinates.
#' The package is developed for the outputs from singular value decompositions (SVD), principal component analysis (PCA), factor analysis (FA), and related methods.
#' Particularly, it focuses on exploring and visualizing multidimensional vectors (singular vectors, principal components, or factors) from dimension reduction techniques or latent variable models.
#'
#' @name svdvis-package
#' @aliases svdvis
#' @docType package
#' @title Singular Value Decomposition Visualization
#' @author Neo Christopher Chung \email{nchchung@gmail.com}

NULL
