% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/id.chol.R
\name{id.chol}
\alias{id.chol}
\title{Recursive identification of SVAR models via Cholesky decomposition}
\usage{
id.chol(x, order_k = NULL)
}
\arguments{
\item{x}{An object of class 'vars', 'vec2var', 'nlVar'. Estimated VAR object}

\item{order_k}{Vector. Vector of characters or integers specifying the assumed structure of the recursive causality. Change the causal ordering in the instantaneous effects without permuting variables and re-estimating the VAR model.}
}
\value{
A list of class "svars" with elements
\item{B}{Estimated structural impact matrix B, i.e. unique decomposition of the covariance matrix of reduced form residuals}
\item{n}{Number of observations}
\item{method}{Method applied for identification}
\item{order_k}{Ordering of the variables as assumed for recursive causality}
\item{A_hat}{Estimated VAR parameter}
\item{type}{Type of the VAR model, e.g. 'const'}
\item{y}{Data matrix}
\item{p}{Number of lags}
\item{K}{Dimension of the VAR}
\item{VAR}{Estimated input VAR object}
}
\description{
Given an estimated VAR model, this function uses the Cholesky decomposition to identify the structural impact matrix B of the corresponding SVAR model
\deqn{y_t=c_t+A_1 y_{t-1}+...+A_p y_{t-p}+u_t
=c_t+A_1 y_{t-1}+...+A_p y_{t-p}+B \epsilon_t.}
Matrix B corresponds to the decomposition of the least squares covariance matrix \eqn{\Sigma_u=B\Lambda_t B'}.
}
\examples{
\donttest{

# data contains quarterly observations from 1965Q1 to 2008Q3
# x = output gap
# pi = inflation
# i = interest rates
set.seed(23211)
v1 <- vars::VAR(USA, lag.max = 10, ic = "AIC" )
x1 <- id.chol(v1)
x2 <- id.chol(v1, order_k = c("pi", "x", "i")) ## order_k = c(2,1,3)
summary(x1)


# impulse response analysis
i1 <- irf(x1, n.ahead = 30)
i2 <- irf(x2, n.ahead = 30)
plot(i1, scales = 'free_y')
plot(i2, scales = 'free_y')


}
}
\references{
Luetkepohl, H., 2005. New introduction to multiple time series analysis, Springer-Verlag, Berlin.
}
\seealso{
For alternative identification approaches see \code{\link{id.st}}, \code{\link{id.cvm}}, \code{\link{id.cv}}, \code{\link{id.dc}} or \code{\link{id.ngml}}
}
