createSyntaxFile <- function (svlfile = "R.svl", pos = 2:length(search()))
{
	## Create an .svl syntax file for R.
	## Note: use only main keywords for keywords2, because it is limited
	## to a little bit less than 32k (2.000 to 2.500 keywords)

	## Create the beginning of the file
	cat(";This is a config file internally used by SciViews.\n",
		file = svlfile)
	cat(";Do not change it manually, except if you exactly know what you are doing!\n\n",
		file = svlfile, append = TRUE)
	cat(";If several items, use a comma-separated list (a, b, ...)\n",
		file = svlfile, append = TRUE)
	cat(";for Options\\AutoIndent: 0=Off, 1=follow language scoping and 2=copy from previous line\n",
		file = svlfile, append = TRUE)
	cat(";Keywords1 are reserved keywords, or preprocessor keywords\n",
		file = svlfile, append = TRUE)
	cat(";for Keywords2, use only the most important ones (you are limited to a total of a little bit less than 32k)!\n\n",
		file = svlfile, append = TRUE)
	cat(";This file is automatically generated from R using createSyntaxFile()\n\n",
		file = svlfile, append = TRUE)

	cat("[General]\n", file = svlfile, append = TRUE)
	cat("Description=Syntax definition for R\n",
		file = svlfile, append = TRUE)
	cat(paste("Version=", R.version$major, ".", R.version$minor, "\n",
		sep = ""), file = svlfile, append = TRUE)
	cat("FileExtensions=*.R\n\n", file = svlfile, append = TRUE)

	cat("[Syntax]\n", file = svlfile, append = TRUE)
	cat("CaseSensitive=1\n", file = svlfile, append = TRUE)
	cat("SingleLineComment=#\n", file = svlfile, append = TRUE)
### TODO: starting from R 2.4.0, "`" inside strings raises a warning => temporarilly disabled
	#cat("ScopeKeywords1={,(,[,[[,$,@,\n", file = svlfile, append = TRUE)
	cat("ScopeKeywords1={,(,[,[[,$,@\n", file = svlfile, append = TRUE)
	#cat("ScopeKeywords2=},),],]],$,@,\n", file = svlfile, append = TRUE)
	cat("ScopeKeywords2=},),],]],$,@\n", file = svlfile, append = TRUE)
	#cat("StringDelimiters=\",',`\n", file = svlfile, append = TRUE)
	cat("StringDelimiters=\",'\n", file = svlfile, append = TRUE)
	cat("EscapeChar=\\\n\n", file = svlfile, append = TRUE)

	cat("[Options]\n", file = svlfile, append = TRUE)
	cat("FixupKeywordCase=0\n", file = svlfile, append = TRUE)
	cat("AutoIndent=1\n", file = svlfile, append = TRUE)
	cat("Tabs=4\n", file = svlfile, append = TRUE)
	cat("ConvertTabsToSpaces=0\n", file = svlfile, append = TRUE)
	cat("ColumnSel=0\n", file = svlfile, append = TRUE)
	cat("HSplitter=0\n", file = svlfile, append = TRUE)
	cat("VSplitter=1\n\n", file = svlfile, append = TRUE)

	cat("[Operators]\n", file = svlfile, append = TRUE)
	cat("-\n!\n!=\n%\n%%\n%*%\n%/%\n%in%\n%o%\n%x%\n&\n&&\n*\n,\n/\n:\n::\n:::\n?\n^\n|\n||\n~\n+\n<\n<-\n<<-\n<=\n=\n==\n>\n->\n>=\n->>\n\n",
		file = svlfile, append = TRUE)

	cat("[Keywords1]\n", file = svlfile, append = TRUE)
	cat("...\n..1\n..2\n..3\n..4\n..5\n..6\n..7\n..8\n..9\nbreak\nelse\nFALSE\nfor\nfunction\nif\nin\nInf\nNA\nNaN\nnext\nNULL\nrepeat\nTRUE\nwhile\n\n",
		file = svlfile, append = TRUE)

	cat("[Keywords2]\n", file = svlfile, append = TRUE)
	write.table(getKeywords(pos = pos), file = svlfile, append = TRUE, quote = FALSE,
		row.names = FALSE, col.names = FALSE)
}
