% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.R
\name{tidy.ypreg}
\alias{tidy.ypreg}
\title{Tidy a ypreg object}
\usage{
\method{tidy}{ypreg}(object, conf.level = 0.95, ...)
}
\arguments{
\item{object}{a fitted model object.}

\item{conf.level}{the confidence level required.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a tibble with a summary of the fit.
}
\description{
Tidy a ypreg object
}
\details{
Convert a fitted model into a tibble.
}
\examples{
\donttest{
library(survstan)
fit <- aftreg(Surv(futime, fustat) ~ ecog.ps + rx, data = ovarian, baseline = "weibull", init = 0)
tidy(fit)
}

}
