% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survminertools.R
\name{kaplan_meier_grid}
\alias{kaplan_meier_grid}
\title{A grid of kaplan meier plots}
\usage{
kaplan_meier_grid(
  ...,
  nrow = NULL,
  ncol = NULL,
  layout_matrix = NULL,
  byrow = T,
  mapped_plot_args = list(),
  paperwidth = NULL,
  paperheight = NULL,
  size_per_plot = dinAWidth(5),
  title = NA,
  surv.plot.height = NULL,
  risk.table.height = NULL,
  ncensor.plot.height = NULL,
  p_lessthan_cutoff = 0.001
)
}
\arguments{
\item{...}{One or many SurvivalAnalysisResult objects as returned by \code{\link{analyse_survival}} and
arguments that will be passed to ggsurvplot.
Bare lists will be spliced.
If using lists, the same argument may be contained in multiple lists;
in this case, the last occurrence is used, i.e. you can first pass a list
with default arguments, and then override some of them.
In addition to all arguments supported by \code{\link{ggsurvplot}}, these arguments and shortcuts can be used additionally:
\itemize{
\item break.time.by: breakByYear, breakByHalfYear, breakByQuarterYear, breakByMonth (numeric value only in ggsurvplot)
\item xscale: scaleByYear, scaleByMonth (numeric value only in ggsurvplot)
\item hazard.ratio (logical): display hazard ratios in addition to p value, complementing pval=T
\item xlab: \{.OS,.PFS,.TTF,.DFS\}.\{years,months,days\}
\item table.layout: clean, displays risk table only with color code and number, no grid, axes or labels.
      (do not forget risk.table=T to see something)
}}

\item{nrow, ncol}{Determines the layout by giving nrow and/or ncol, if missing, uses an auto layout.}

\item{layout_matrix}{Optionally specify a layout matrix, which is passed to \code{gridExtra::\link{marrangeGrob}}}

\item{byrow}{If no layout_matrix is specified and there are multiple rows: How should the plots by layout?
The order of the plots can be by-row (default) or by-col (set byrow=F).}

\item{mapped_plot_args}{Optionally, if given n objects to plot, a named list of vectors of size n.
The name is an argument names passed to ggsurvplot. The elements of the vector will be mapped 1:1 to each object.
This allows to perform batch plotting where only few arguments differ (e.g. titles A, B, C...) between the plots.
Please note that only object that need plotting (survival_analysis results) are considered, not those that
are already plotted (kaplan_meier_plot results)}

\item{paperwidth, paperheight, size_per_plot}{You can specify the size per plot, or the full paper width and height.
size_per_plot may be a number (width == height) or two-dimensional, width and height.
The resulting paper size will be stored as a papersize attribute that is e.g.
read by \code{tidytidbits::\link{save_pdf}}}

\item{title, surv.plot.height, risk.table.height, ncensor.plot.height}{Passed to \code{\link[survminer]{arrange_ggsurvplots}}}

\item{p_lessthan_cutoff}{The lower limit below which p value will be displayed as "less than".
If p_lessthan_cutoff == 0.001, the a p value of 0.002 will be displayed as is, while 0.0005 will become "p < 0.001".}
}
\value{
An object of class arrangelist, which can be printed or saved to pdf with ggsave().
}
\description{
A grid of kaplan meier plots
}
