% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_surv_ceteris_paribus.R
\name{plot.surv_ceteris_paribus}
\alias{plot.surv_ceteris_paribus}
\title{Plot Predict Profile for Survival Models}
\usage{
\method{plot}{surv_ceteris_paribus}(
  x,
  ...,
  colors = NULL,
  variable_type = NULL,
  facet_ncol = NULL,
  variables = NULL,
  numerical_plot_type = "lines",
  title = "Ceteris paribus survival profile",
  subtitle = "default",
  rug = "all",
  rug_colors = c("#dd0000", "#222222")
)
}
\arguments{
\item{x}{an object of class \code{predict_profile_survival} to be plotted}

\item{...}{additional objects of class \code{"predict_profile_survival"} to be plotted together}

\item{colors}{character vector containing the colors to be used for plotting variables (containing either hex codes "#FF69B4", or names "blue")}

\item{variable_type}{character, either \code{"numerical"}, \code{"categorical"} or \code{NULL} (default), select only one type of variable for plotting, or leave \code{NULL} for all}

\item{facet_ncol}{number of columns for arranging subplots}

\item{variables}{character, names of the variables to be plotted}

\item{numerical_plot_type}{character, either \code{"lines"}, or \code{"contours"} selects the type of numerical variable plots}

\item{title}{character, title of the plot}

\item{subtitle}{character, subtitle of the plot, \code{'default'} automatically generates "created for XXX, YYY models", where XXX and YYY are the explainer labels}

\item{rug}{character, one of \code{"all"}, \code{"events"}, \code{"censors"}, \code{"none"} or \code{NULL}. Which times to mark on the x axis in \code{geom_rug()}.}

\item{rug_colors}{character vector containing two colors (containing either hex codes \code{"#FF69B4"}, or names \code{"blue"}). The first color (red by default) will be used to mark event times, whereas the second (grey by default) will be used to mark censor times.}
}
\value{
A collection of \code{ggplot} objects arranged with the \code{patchwork} package.
}
\description{
This function plots objects of class \code{"predict_profile_survival"} created using
the \code{predict_profile()} function.
}
\examples{
\donttest{
library(survival)
library(survex)

model <- randomForestSRC::rfsrc(Surv(time, status) ~ ., data = veteran)
exp <- explain(model)

p_profile <- predict_profile(exp, veteran[1, -c(3, 4)])

plot(p_profile)

p_profile_with_cat <- predict_profile(
    exp,
    veteran[1, -c(3, 4)],
    categorical_variables = c("trt", "prior")
)

plot(p_profile_with_cat)
}

}
\seealso{
Other functions for plotting 'predict_profile_survival' objects: 
\code{\link{plot.predict_profile_survival}()}
}
\concept{functions for plotting 'predict_profile_survival' objects}
