% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/num_check.R
\name{num_check}
\alias{num_check}
\title{Check a Column for Non-Numbers}
\usage{
num_check(data = NULL, col = NULL)
}
\arguments{
\item{data}{(dataframe) object containing at least one column of supposed dates}

\item{col}{(character or numeric) name or column number of the column containing putative dates in the data object}
}
\value{
(character) vector of malformed dates
}
\description{
Any elements in the column that would be changed to NA if \code{as.numeric} is used on the column are returned. This is useful for quickly identifying only the "problem" entries of an ostensibly numeric column that is read in as a character.
}
\examples{
# Create dataframe with a numeric column where some entries would be coerced into NA
spp <- c('salmon', 'bass', 'halibut', 'eel')
ct <- c(1, '14x', '_23', 12)
fish <- data.frame('species' = spp, 'count' = ct)

# Use `num_check()` to return only the entries that would be lost
num_check(data = fish, col = "count")
}
