% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMoonTimes.R
\name{getMoonTimes}
\alias{getMoonTimes}
\title{Get Moon times}
\usage{
getMoonTimes(date = NULL, lat = NULL, lon = NULL, data = NULL,
  keep = c("rise", "set", "alwaysUp", "alwaysDown"), tz = "UTC",
  inUTC = FALSE)
}
\arguments{
\item{date}{: \code{Date}. Single or multiple Date. YYYY-MM-DD}

\item{lat}{: \code{numeric}. Single latitude}

\item{lon}{: \code{numeric}. Single longitude}

\item{data}{: \code{data.frame}. Alternative to use \code{date}, \code{lat}, \code{lon} for passing multiple coordinates}

\item{keep}{: \code{character}. Vector of variables to keep. See \code{Details}}

\item{tz}{: \code{character}. Timezone of results}

\item{inUTC}{: \code{logical}. By default, it will search for moon rise and set during local user's day (from 0 to 24 hours). If TRUE, it will instead search the specified date from 0 to 24 UTC hours.}
}
\value{
\code{data.frame}
}
\description{
Get Moon times
}
\details{
Available variables are :

\itemize{
  \item{"rise"}{ : \code{Date}. moonrise time}
  \item{"set"}{ : \code{Date}. moonset time}
  \item{"alwaysUp"}{ : \code{Logical}. TRUE if the moon never rises or sets and is always above the horizon during the day}
  \item{"alwaysDown"}{ : \code{Logical}. TRUE if the moon is always below the horizon}
}
}
\examples{

# one date
getMoonTimes(date = Sys.Date(), lat = 47.21, lon = -1.557, tz = "CET")

# multiple date + subset
getMoonTimes(date = seq.Date(Sys.Date()-9, Sys.Date(), by = 1), 
  keep = c("rise", "set", "alwaysUp"), 
  lat = 47.21, lon = -1.557, tz = "CET")
  
# multiple coordinates
data <- data.frame(date = seq.Date(Sys.Date()-9, Sys.Date(), by = 1), 
    lat = c(rep(50.1, 10), rep(49, 10)), 
    lon = c(rep(1.83, 10), rep(2, 10)))
    
getMoonTimes(data = data, tz = "CET")
      
}
\seealso{
\link{getSunlightTimes}, \link{getMoonTimes}, \link{getMoonIllumination},
\link{getMoonPosition},\link{getSunlightPosition}
}
