% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_args.R
\name{parse_args}
\alias{parse_args}
\title{Extract Data Information From Arguments Passed to Functions}
\usage{
parse_args(sys_calls, sys_frames, match_call, var = "x")
}
\arguments{
\item{sys_calls}{Object created using \code{sys.calls()}.}

\item{sys_frames}{Object created using \code{sys.frames()}.}

\item{match_call}{Object created using \code{match.call()}.}

\item{var}{One of \dQuote{x} or \dQuote{y} (the latter being used only
in \code{\link{ctable}}).}
}
\value{
A list comprised of:
\itemize{
  \item df_name The data frame name when applicable.
  \item var_names The variable names when applicable.
  \item rows_subset The subsetting condition when applicable.
  \item by_group The group, when functions are called through
    \code{by()}
  \item by_first A binary indicator used when function was called
    through \code{by()}
  \item by_last A binary indicator used when function was called
    through \code{by()}}
}
\description{
Using sys.calls(), sys.frames() and match.call(), this utility function
extracts and/or deducts information about the data being processed.
Data frame name, variable names and labels if any, subsetting information,
grouping information (when by() is used) are returned by the function which
tries various methods to get this information.
}
\details{
The default \code{plain.ascii = TRUE} option is there to make
  results appear cleaner in the console. To avoid markdown rendering
  problems, the option is automatically set to \code{FALSE} whenever
  \code{style = 'rmarkdown'}, unless \code{plain.ascii = TRUE} is made
  explicit. If the intent is to produce \emph{rmarkdown} text for further
  processing while using \code{style = 'simple'}, set \code{plain.ascii} to
  \code{FALSE}.
}
\author{
Dominic Comtois, \email{dominic.comtois@gmail.com>}
}
\keyword{internal}
\keyword{misc}
