\name{plot.sample.size}
\alias{plot.sample.size}
\title{Plot Classification Accuracy for Short Text Samples}
\description{
Plotting method for objects of the class \code{"stylo.results"}, produced by 
the function \code{\link{size.penalize}}. It can be used to show the behavior 
of short samples in text classification. See the help page of 
\code{\link{size.penalize}} for further details.
}
\usage{
\method{plot}{sample.size}(x, target = NULL, variable = "diversity",
      trendline = TRUE, observations = FALSE,
      grayscale = FALSE, legend = TRUE, 
      legend_pos = "bottomright", ...)
}    
\arguments{
  \item{x}{an object of class \code{"stylo.results"} as produced by
      the function \code{size.penalize}.}
  \item{target}{the number of the text to be plotted, or its name as
      stored in the \code{"stylo.results"} object (see the examples below). 
      Both ways are equivalent, where a numeric value represents the n-th text.
      If no target is specified, then the first text is plotted.}
  \item{variable}{choose either \code{"accuracy"} to get the classification 
      accuracy, i.e. the ratio of correctly attributed instances to the number 
      iterations (usually 100, see the help page of \code{\link{size.penalize}} 
      for further details), or \code{"diversity"} to get Simpson's index 
      of class imbalance (this is the default value). The index provides you 
      with the information how consistent was a classifier in its choices.}
  \item{trendline}{since all the observations represented in the plot might be 
      difficult to read, one can use a trendline instead (default). The 
      trendlines are produced using the generic \code{lowess} function.}
  \item{observations}{particular observations and a trendline (see above) can
      be combined. Switch this option on, to do so (default: \code{FALSE}).}
  \item{grayscale}{using this option, you can switch off colors.}
  \item{legend}{do you want to have the trendlines and/or observations
      explained? Switch this option on (which is default).}
  \item{legend_pos}{position of the legend: choose between 
      \code{"bottomright"}, \code{"bottomleft"}, \code{"topright"}
      and \code{"topleft"}.}
  \item{\dots}{further arguments to be passed to \code{plot}.}
}
\details{
An object generated by the \code{\link{size.penalize}} function can be of course
split into its parts and plotted using any other routine. The method discussed
in this document is a simple shortcut: rather than refine your plot parameters 
from scratch, you can get acceptable results by using one single generic 
function \code{plot}; see a few examples below.
}
\author{Maciej Eder}
\seealso{
  \code{\link{size.penalize}}
}
\examples{
\dontrun{
# provided that there exists a text collection (text files)
# in the subdirectory 'corpus', perform a test for sample size:
results = size.penalize(corpus.dir = "corpus")

# then plot the first text's classification accuracy:
plot(results)

# plot the results, e.g. for the 5th text:
plot(results, target = 5)

# the 'target' parameter can be set via the text's name, 
# to see which texts are available in the results, type: 
results$test.texts

# plot Simpson's diversity index for the text named 'Woolf_Years_1937':
plot(results_classic, target = "Woolf_Years_1937", variable = "diversity")

}
}

