% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testing.R
\name{test_collection}
\alias{test_collection}
\title{Run a collection of tests}
\usage{
test_collection(test, sub_test = NULL, write_back = TRUE, write_tree = NA,
  transformer, ...)
}
\arguments{
\item{test}{The test to run. It corresponds to a folder name in
tests/testthat.}

\item{sub_test}{A regex pattern to further reduce the amount of test files
to be tested in the test. \code{sub_test} must match the beginning of file
names in tests/testthat. \code{NULL} matches all files.}

\item{write_back}{Whether the results of the transformation should be written
to the output file.}

\item{write_tree}{Whether or not the tree structure of the test should be
computed and written to a file. Note that this needs R >= 3.2
(see \code{\link[=set_arg_write_tree]{set_arg_write_tree()}}). If the argument is set to \code{NA}, the function
determines whether R >= 3.2 is in use and if so, trees will be written.}

\item{transformer}{A function to apply to the content of \code{in_item}.}

\item{...}{Parameters passed to transformer function.}
}
\description{
Run transformations on all *-in.R files in a test directory and compare them
with their *-out.R counterpart.
}
\details{
Each file name that matches \code{test} and \code{sub_test} and ends with
"-in.R" is considered as an input to test. Its counterpart,
the reference to compare it against is the *-out.R file. It is constructed
by taking the substring of the *-in.R file before the
first dash and adding -out.R. This allows for multiple in.R files to
share one out.R file. You could have one_line-out.R as the reference to
compare one_line-random-something-stuff-in.R and
one_line-random-but-not-so-much-in.R.

This also implies that -out.R files cannot have more than one dash in
their name, i.e. just the one before out.R.
}
\keyword{internal}
