% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/tableCapillary.r
\name{tableCapillary}
\alias{tableCapillary}
\title{Table Capillary}
\usage{
tableCapillary(data, scope = "cap", debug = FALSE)
}
\arguments{
\item{data}{data frame from a capillary analysis by \code{calculateCapillary}.}

\item{scope}{character string. Make table by capillary, injection, plate row,
run, or instrument. Values {"cap", "inj", "row", "run", "instr"}.}

\item{debug}{logical indicating printing debug information.}
}
\value{
data.frame with columns 'Instrument', 'Capillary/Injection/Row/Run/Instrument',
'N', 'Min', 'Q1', 'Median', 'Mean', 'Q3', 'Max', 'Std.Dev'.
}
\description{
Summarize capillary analysis result in table format.
}
\details{
Summarize the capillary analysis result in table format by capillary,
injection, plate row, or instrument. Returns a dataframe with number of
observations, min, max, median, mean, standard deviation, and the 25th
and 75th percentile.
}

