% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOdatetime.R
\name{ISOdatetime}
\alias{ISOdatetime}
\alias{ISOdate}
\alias{Sys.time}
\title{Construct Date-time Objects}
\usage{
ISOdatetime(
  year,
  month,
  day,
  hour,
  min,
  sec,
  tz = "",
  lenient = FALSE,
  locale = NULL
)

ISOdate(
  year,
  month,
  day,
  hour = 0L,
  min = 0L,
  sec = 0L,
  tz = "",
  lenient = FALSE,
  locale = NULL
)

Sys.time()
}
\arguments{
\item{year, month, day, hour, min, sec}{numeric vectors}

\item{tz}{\code{NULL} or \code{''} for the default time zone
(see \code{\link[stringi]{stri_timezone_get}})
or a single string with a timezone identifier,
see \code{\link[stringi]{stri_timezone_list}}}

\item{lenient}{single logical value; should date/time parsing be lenient?}

\item{locale}{\code{NULL} or \code{''} for the default locale
(see \code{\link[stringi]{stri_locale_get}})
or a single string with a locale identifier,
see \code{\link[stringi]{stri_locale_list}}}
}
\value{
These functions return an object of class \code{POSIXxt}, which
extends upon \code{\link[base]{POSIXct}}, \code{\link{strptime}}.

You might wish to consider calling \code{\link{as.Date}} on
the result yielded by \code{ISOdate}.

No attributes are preserved (because they are too many).
}
\description{
\code{ISOdate} and \code{ISOdatetime} construct date-time objects
from numeric representations.
\code{Sys.time} returns current time.
}
\section{Differences from Base R}{

Replacements for base \code{\link[base]{ISOdatetime}}
and \code{\link[base]{ISOdate}} implemented with
\code{\link[stringi]{stri_datetime_create}}.

\itemize{
\item \code{ISOdate} does not treat dates as being at midnight
    by default \bold{[fixed here]}
}
}

\examples{
ISOdate(1970, 1, 1)
ISOdatetime(1970, 1, 1, 12, 0, 0)

}
\seealso{
The official online manual of \pkg{stringx} at \url{https://stringx.gagolewski.com/}

Related function(s): \code{\link{strptime}}
}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski}
}
