% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interp.R
\name{str_interp}
\alias{str_interp}
\title{String interpolation.}
\usage{
str_interp(string, env = parent.frame())
}
\arguments{
\item{string}{A template character string. This function is not vectorised:
a character vector will be collapsed into a single string.}

\item{env}{The environment in which to evaluate the expressions.}
}
\value{
An interpolated character string.
}
\description{
String interpolation is a useful way of specifying a character string which
depends on values in a certain environment. It allows for string creation
which is easier to read and write when compared to using e.g.
\code{\link[=paste]{paste()}} or \code{\link[=sprintf]{sprintf()}}. The (template) string can
include expression placeholders of the form \verb{$\{expression\}} or
\verb{$[format]\{expression\}}, where expressions are valid R expressions that
can be evaluated in the given environment, and \code{format} is a format
specification valid for use with \code{\link[=sprintf]{sprintf()}}.
}
\examples{

# Using values from the environment, and some formats
user_name <- "smbache"
amount <- 6.656
account <- 1337
str_interp("User ${user_name} (account $[08d]{account}) has $$[.2f]{amount}.")

# Nested brace pairs work inside expressions too, and any braces can be
# placed outside the expressions.
str_interp("Works with } nested { braces too: $[.2f]{{{2 + 2}*{amount}}}")

# Values can also come from a list
str_interp(
  "One value, ${value1}, and then another, ${value2*2}.",
  list(value1 = 10, value2 = 20)
)

# Or a data frame
str_interp(
  "Values are $[.2f]{max(Sepal.Width)} and $[.2f]{min(Sepal.Width)}.",
  iris
)

# Use a vector when the string is long:
max_char <- 80
str_interp(c(
  "This particular line is so long that it is hard to write ",
  "without breaking the ${max_char}-char barrier!"
))
}
\seealso{
\code{\link[=str_glue]{str_glue()}} and \code{\link[=str_glue_data]{str_glue_data()}} for alternative approaches to
the same problem.
}
\author{
Stefan Milton Bache
}
\keyword{internal}
