% Generated by roxygen2 (4.0.2): do not edit by hand
\name{stri_subset}
\alias{stri_subset}
\alias{stri_subset_charclass}
\alias{stri_subset_coll}
\alias{stri_subset_fixed}
\alias{stri_subset_regex}
\title{Select Elements that Match a Given Pattern}
\usage{
stri_subset(str, ..., regex, fixed, coll, charclass)

stri_subset_fixed(str, pattern)

stri_subset_charclass(str, pattern)

stri_subset_coll(str, pattern, opts_collator = NULL)

stri_subset_regex(str, pattern, opts_regex = NULL)
}
\arguments{
\item{str}{character vector with strings to search in}

\item{...}{additional arguments passed to the underlying functions;
\code{stri_subset} only}

\item{pattern,regex,fixed,coll,charclass}{character vector defining search patterns;
for more details refer to \link{stringi-search}}

\item{opts_collator}{a named list with \pkg{ICU} Collator's settings
as generated with \code{\link{stri_opts_collator}}; \code{NULL}
for default settings;
\code{stri_subset_coll} only}

\item{opts_regex}{a named list with \pkg{ICU} Regex settings
as generated with \code{\link{stri_opts_regex}}; \code{NULL}
for default settings;
\code{stri_subset_regex} only}
}
\value{
All the functions return a character vector.
Of course, the output encoding is always UTF-8.
}
\description{
These functions return a subvector consisting of
strings that match a given pattern. In other words, they
are roughly equivalent (but faster and easier to use) to a call to
\code{str[\link{stri_detect}(str, ...)]}.
}
\details{
Vectorized over \code{str} and \code{pattern}.

\code{stri_subset} is a convenience function.
It calls either \code{stri_subset_regex},
\code{stri_subset_fixed}, \code{stri_subset_coll},
or \code{stri_subset_charclass},
depending on the argument used.
Unless you are a very lazy person, please call the underlying functions
directly for better performance.
}
\examples{
\donttest{
stri_subset_fixed(c("stringi R", "REXAMINE", "123"), c('i', 'R', '0'))
stri_subset_fixed(c("stringi R", "REXAMINE", "123"), 'R')
stri_subset_charclass(c("stRRRingi","REXAMINE","123"),
   c("\\\\p{Ll}", "\\\\p{Lu}", "\\\\p{Zs}"))
}
}
\seealso{
Other search_subset: \code{\link{stringi-search}}
}

