% Generated by roxygen2 (4.0.0): do not edit by hand
\name{stri_compare}
\alias{stri_cmp}
\alias{stri_cmp_eq}
\alias{stri_cmp_equiv}
\alias{stri_cmp_ge}
\alias{stri_cmp_gt}
\alias{stri_cmp_le}
\alias{stri_cmp_lt}
\alias{stri_cmp_neq}
\alias{stri_cmp_nequiv}
\alias{stri_compare}
\title{Compare Strings with or without Collation}
\usage{
stri_compare(e1, e2, opts_collator = NULL)

stri_cmp(e1, e2, opts_collator = NULL)

stri_cmp_eq(e1, e2)

stri_cmp_neq(e1, e2)

stri_cmp_equiv(e1, e2, opts_collator = NULL)

stri_cmp_nequiv(e1, e2, opts_collator = NULL)

stri_cmp_lt(e1, e2, opts_collator = NULL)

stri_cmp_gt(e1, e2, opts_collator = NULL)

stri_cmp_le(e1, e2, opts_collator = NULL)

stri_cmp_ge(e1, e2, opts_collator = NULL)
}
\arguments{
\item{e1,e2}{character vectors or objects coercible to character vectors}

\item{opts_collator}{a named list with \pkg{ICU} Collator's options
as generated with \code{\link{stri_opts_collator}}, \code{NULL}
for default collation options.}
}
\value{
The \code{stri_cmp} and \code{stri_compare} functions
return an integer vector
with comparison results of corresponding
pairs of elements in \code{e1} and \code{e2}:
\code{-1} if \code{e1[...] < e2[...]},
\code{0} if they are canonically equivalent, and \code{1} if greater.

The other functions return a logical vector that indicates
whether a given relation holds between two corresponding elements
in \code{e1} and \code{e2}.
}
\description{
These functions  may be used to determine if two strings
are equal, canonically equivalent (this is performed in a way more clever
fashion than when testing for equality),
or to check whether they appear in
a specific lexicographic order.
}
\details{
All the functions are vectorized over \code{e1} and \code{e2}.

\code{stri_cmp_eq} tests whether two corresponding strings
consist of exactly the same code points, while \code{stri_cmp_neq} allow
to check whether there is any difference between them.
These are locale-independent operations: for
natural language text processing, in which the notion of canonical equivalence
is more valid, this may not be exactly what
you are looking for, see Examples.
Also note that \pkg{stringi} always silently removes UTF-8
BOMs from input strings,
so e.g. \code{stri_cmp_eq} does not take BOMs into account while
comparing strings.

On the other hand, \code{stri_cmp_equiv} test for
canonical equivalence of two strings and is locale-dependent.
Additionally, the \pkg{ICU}'s Collator may be tuned up so that
e.g. the comparison is case-insensitive.
To test whether two strings are not canonically equivalent,
call \code{stri_cmp_nequiv}.

What is more,  \code{stri_cmp_le} tests whether
the elements in the first vector are less than or equal to
the corresponding elements in the second vector,
\code{stri_cmp_ge} whether they are greater or equal,
\code{stri_cmp_lt} if less,
and \code{stri_cmp_gt} if greater,
see also e.g. \code{\link{\%<\%}}.

Finally, \code{stri_compare} is an alias to \code{stri_cmp}. They both
perform exactly the same locale-dependent operation.
Both functions provide a C library's \code{strcmp()} look-and-feel,
see Value for details.


For more information on \pkg{ICU}'s Collator and how to tune it up
in \pkg{stringi}, refer to \code{\link{stri_opts_collator}}.
Please note that different locale settings may lead to different results
(see the examples below).
}
\examples{
stri_cmp_lt("hladny", "chladny", stri_opts_collator(locale="pl_PL")) # in Polish ch < h
stri_cmp_lt("hladny", "chladny", stri_opts_collator(locale="sk_SK")) # in Slovak ch > h
stri_cmp("hladny", "chladny") # < or > (depends on locale)
stri_cmp_equiv("hladny", "HLADNY", stri_opts_collator(strength=2))
stri_cmp_equiv("hladn\\u00FD", "hladny", stri_opts_collator(strength=1, locale="sk_SK"))
stri_cmp_equiv(stri_trans_nfkd('\\u0105'), '\\u105')
stri_cmp_eq(stri_trans_nfkd('\\u0105'), '\\u105') # note the difference
stri_cmp_equiv("\\ufb00", "ff", stri_opts_collator(strength=2))
}
\seealso{
Other locale_sensitive: \code{\link{\%!==\%}},
  \code{\link{\%!=\%}}, \code{\link{\%<=\%}},
  \code{\link{\%<\%}}, \code{\link{\%===\%}},
  \code{\link{\%==\%}}, \code{\link{\%>=\%}},
  \code{\link{\%>\%}}, \code{\link{\%stri!==\%}},
  \code{\link{\%stri!=\%}}, \code{\link{\%stri<=\%}},
  \code{\link{\%stri<\%}}, \code{\link{\%stri===\%}},
  \code{\link{\%stri==\%}}, \code{\link{\%stri>=\%}},
  \code{\link{\%stri>\%}}; \code{\link{stri_count_coll}};
  \code{\link{stri_detect_coll}};
  \code{\link{stri_duplicated}},
  \code{\link{stri_duplicated_any}};
  \code{\link{stri_enc_detect2}};
  \code{\link{stri_extract_all_coll}},
  \code{\link{stri_extract_first_coll}},
  \code{\link{stri_extract_first_coll}},
  \code{\link{stri_extract_last_coll}},
  \code{\link{stri_extract_last_coll}};
  \code{\link{stri_extract_words}};
  \code{\link{stri_locate_all_coll}},
  \code{\link{stri_locate_first_coll}},
  \code{\link{stri_locate_first_coll}},
  \code{\link{stri_locate_last_coll}},
  \code{\link{stri_locate_last_coll}};
  \code{\link{stri_locate_boundaries}};
  \code{\link{stri_locate_words}};
  \code{\link{stri_opts_collator}};
  \code{\link{stri_order}}, \code{\link{stri_sort}};
  \code{\link{stri_replace_all_coll}},
  \code{\link{stri_replace_first_coll}},
  \code{\link{stri_replace_first_coll}},
  \code{\link{stri_replace_last_coll}},
  \code{\link{stri_replace_last_coll}};
  \code{\link{stri_split_boundaries}};
  \code{\link{stri_split_coll}};
  \code{\link{stri_trans_tolower}},
  \code{\link{stri_trans_totitle}},
  \code{\link{stri_trans_toupper}};
  \code{\link{stri_unique}}; \code{\link{stri_wrap}};
  \code{\link{stringi-locale}};
  \code{\link{stringi-search-coll}}
}

