% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phonetic.R
\name{phonetic}
\alias{phonetic}
\title{Phonetic algorithms}
\usage{
phonetic(x, method = c("soundex"), useBytes = FALSE)
}
\arguments{
\item{x}{a character vector whose elements are phonetically encoded.}

\item{method}{name of the algorithm used. The default is \code{"soundex"}.}

\item{useBytes}{Perform byte-wise comparison. \code{useBytes=TRUE} is faster 
but may yield different results depending on character encoding. For more
information see the documentation of \code{\link{stringdist}}.}
}
\value{
The returns value depends on the method used. However, all currently 
implemented methods return a character vector of the same length of the input
vector. Output characters are in the system's native encoding.
}
\description{
Translate strings to phonetic codes. Similar sounding strings should get 
similar or equal codes.
}
\details{
Currently, only the soundex algorithm is implemented. Note that soundex coding
is only meaningful for characters in the ranges a-z and A-Z. Soundex coding of strings 
containing non-printable ascii or non-ascii characters may be system-dependent and should 
not be trusted. If non-ascii or non-printable ascii charcters are encountered, a warning 
is emitted.
}
\examples{
# The following examples are from The Art of Computer Programming (part III, p. 395)
# (Note that our algorithm is specified different from the one in TACP, see references.)
phonetic(c('Euler','Gauss','Hilbert','Knuth','Lloyd','Lukasiewicz','Wachs'),method='soundex')


}
\references{
\itemize{
\item{The Soundex algorithm implemented is the algorithm used by the 
  \href{https://www.archives.gov/research/census/soundex}{National Archives}. 
  This algorithm differs slightly from the original algorithm patented by R.C. Russell 
  (US patents 1261167 (1918) and 1435663 (1922)). 
}
}
}
\seealso{
\code{\link{printable_ascii}}, \code{\link{stringdist-package}}
}
