% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/give-ext.R
\name{str_give_ext}
\alias{str_give_ext}
\title{Ensure a file name has the intended extension.}
\usage{
str_give_ext(string, ext, replace = FALSE)
}
\arguments{
\item{string}{The intended file name.}

\item{ext}{The intended file extension (with or without the ".").}

\item{replace}{If the file has an extension already, replace it (or append
the new extension name)?}
}
\value{
A string: the file name in your intended form.
}
\description{
Say you want to ensure a name is fit to be the name of a csv file. Then, if
the input doesn't end with ".csv", this function will tack ".csv" onto the
end of it. This is vectorized over the first argument.
}
\examples{
str_give_ext(c("abc", "abc.csv"), "csv")
str_give_ext("abc.csv", "pdf")
str_give_ext("abc.csv", "pdf", replace = TRUE)
}
\concept{appenders}
