/*
 * Decompiled with CFR 0.152.
 */
package moa.evaluation;

import com.yahoo.labs.samoa.instances.DenseInstance;
import java.util.ArrayList;
import moa.cluster.Cluster;
import moa.cluster.Clustering;
import moa.cluster.SphereCluster;
import moa.evaluation.MeasureCollection;
import moa.gui.visualization.DataPoint;

public class Separation
extends MeasureCollection {
    @Override
    protected String[] getNames() {
        return new String[]{"BSS", "BSS-GT", "BSS-Ratio"};
    }

    private double getBSS(Clustering clustering, double[] mean) {
        double bss = 0.0;
        for (int i = 0; i < clustering.size(); ++i) {
            double weight = clustering.get(i).getWeight();
            double sum = 0.0;
            for (int j = 0; j < mean.length; ++j) {
                sum += Math.pow(mean[j] - clustering.get(i).getCenter()[j], 2.0);
            }
            bss += weight * sum;
        }
        return bss;
    }

    @Override
    protected void evaluateClustering(Clustering clustering, Clustering trueClustering, ArrayList<DataPoint> points) throws Exception {
        double BSS_GT = 1.0;
        int dimension = points.get(0).numAttributes() - 1;
        SphereCluster sc = new SphereCluster(points, dimension);
        double BSS = this.getBSS(clustering, sc.getCenter());
        if (trueClustering != null) {
            String s = "";
            ArrayList<DenseInstance> listInstances = new ArrayList<DenseInstance>();
            for (Cluster c : trueClustering.getClustering()) {
                DenseInstance inst = new DenseInstance(c.getWeight(), c.getCenter());
                listInstances.add(inst);
                s = s + " " + c.getWeight();
            }
            SphereCluster gt = new SphereCluster(listInstances, dimension);
            BSS_GT = this.getBSS(trueClustering, gt.getCenter());
        }
        this.addValue("BSS", BSS);
        this.addValue("BSS-GT", BSS_GT);
        this.addValue("BSS-Ratio", BSS / BSS_GT);
    }
}

