/*
 * Decompiled with CFR 0.152.
 */
package moa.evaluation;

import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.MultiLabelInstance;
import com.yahoo.labs.samoa.instances.Prediction;
import moa.AbstractMOAObject;
import moa.core.Example;
import moa.core.Measurement;
import moa.evaluation.MultiTargetPerformanceEvaluator;
import moa.evaluation.RegressionPerformanceEvaluator;

public class BasicMultiTargetPerformanceEvaluator
extends AbstractMOAObject
implements MultiTargetPerformanceEvaluator,
RegressionPerformanceEvaluator {
    private static final long serialVersionUID = 1L;
    protected double weightObserved;
    protected double squareError;
    protected double averageError;
    protected int numberOutputs;

    @Override
    public void reset() {
        this.weightObserved = 0.0;
        this.squareError = 0.0;
        this.averageError = 0.0;
    }

    @Override
    public void addResult(Example<Instance> example, Prediction prediction) {
        MultiLabelInstance inst = (MultiLabelInstance)example.getData();
        if (this.numberOutputs == 0) {
            this.numberOutputs = inst.numberOutputTargets();
        }
        if (inst.weight() > 0.0) {
            this.weightObserved += inst.weight();
            if (prediction != null) {
                for (int i = 0; i < this.numberOutputs; ++i) {
                    double err = inst.classValue(i) - (prediction.numOutputAttributes() == 0 ? 0.0 : prediction.getVote(i, 0));
                    this.squareError += err * err;
                    this.averageError += Math.abs(err);
                }
            }
        }
    }

    @Override
    public Measurement[] getPerformanceMeasurements() {
        return new Measurement[]{new Measurement("classified instances", this.getTotalWeightObserved()), new Measurement("mean absolute error", this.getMeanError()), new Measurement("root mean squared error", this.getSquareError())};
    }

    public double getTotalWeightObserved() {
        return this.weightObserved;
    }

    public double getMeanError() {
        return this.weightObserved > 0.0 ? this.averageError / (this.weightObserved * (double)this.numberOutputs) : 0.0;
    }

    public double getSquareError() {
        return Math.sqrt(this.weightObserved > 0.0 ? this.squareError / (this.weightObserved * (double)this.numberOutputs) : 0.0);
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
        Measurement.getMeasurementsDescription(this.getPerformanceMeasurements(), sb, indent);
    }

    @Override
    public void addResult(Example<Instance> example, double[] classVotes) {
    }
}

