/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers;

import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.Instances;
import com.yahoo.labs.samoa.instances.InstancesHeader;
import com.yahoo.labs.samoa.instances.MultiLabelPrediction;
import com.yahoo.labs.samoa.instances.Prediction;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Random;
import moa.MOAObject;
import moa.classifiers.Classifier;
import moa.classifiers.SemiSupervisedLearner;
import moa.core.Example;
import moa.core.Measurement;
import moa.core.ObjectRepository;
import moa.core.StringUtils;
import moa.core.Utils;
import moa.gui.AWTRenderer;
import moa.learners.Learner;
import moa.options.AbstractOptionHandler;
import moa.tasks.TaskMonitor;

public abstract class AbstractClassifier
extends AbstractOptionHandler
implements Classifier {
    protected InstancesHeader modelContext;
    protected double trainingWeightSeenByModel = 0.0;
    protected int randomSeed = 1;
    protected IntOption randomSeedOption;
    public Random classifierRandom;

    @Override
    public String getPurposeString() {
        return "MOA Classifier: " + this.getClass().getCanonicalName();
    }

    public AbstractClassifier() {
        if (this.isRandomizable()) {
            this.randomSeedOption = new IntOption("randomSeed", 'r', "Seed for random behaviour of the classifier.", 1);
        }
    }

    @Override
    public void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
        if (this.randomSeedOption != null) {
            this.randomSeed = this.randomSeedOption.getValue();
        }
        if (!this.trainingHasStarted()) {
            this.resetLearning();
        }
    }

    @Override
    public double[] getVotesForInstance(Example<Instance> example) {
        return this.getVotesForInstance(example.getData());
    }

    @Override
    public abstract double[] getVotesForInstance(Instance var1);

    @Override
    public Prediction getPredictionForInstance(Example<Instance> example) {
        return this.getPredictionForInstance(example.getData());
    }

    @Override
    public Prediction getPredictionForInstance(Instance inst) {
        MultiLabelPrediction prediction = new MultiLabelPrediction(1);
        prediction.setVotes(this.getVotesForInstance(inst));
        return prediction;
    }

    @Override
    public void setModelContext(InstancesHeader ih) {
        if (ih != null && ih.classIndex() < 0) {
            throw new IllegalArgumentException("Context for a classifier must include a class to learn");
        }
        if (this.trainingHasStarted() && this.modelContext != null && (ih == null || !AbstractClassifier.contextIsCompatible(this.modelContext, ih))) {
            throw new IllegalArgumentException("New context is not compatible with existing model");
        }
        this.modelContext = ih;
    }

    @Override
    public InstancesHeader getModelContext() {
        return this.modelContext;
    }

    @Override
    public void setRandomSeed(int s) {
        this.randomSeed = s;
        if (this.randomSeedOption != null) {
            this.randomSeedOption.setValue(s);
        }
    }

    @Override
    public boolean trainingHasStarted() {
        return this.trainingWeightSeenByModel > 0.0;
    }

    @Override
    public double trainingWeightSeenByModel() {
        return this.trainingWeightSeenByModel;
    }

    @Override
    public void resetLearning() {
        this.trainingWeightSeenByModel = 0.0;
        if (this.isRandomizable()) {
            this.classifierRandom = new Random(this.randomSeed);
        }
        this.resetLearningImpl();
    }

    @Override
    public void trainOnInstance(Instance inst) {
        boolean isTraining;
        boolean bl = isTraining = inst.weight() > 0.0;
        if (!(this instanceof SemiSupervisedLearner) && inst.classIsMissing()) {
            isTraining = false;
        }
        if (isTraining) {
            this.trainingWeightSeenByModel += inst.weight();
            this.trainOnInstanceImpl(inst);
        }
    }

    @Override
    public Measurement[] getModelMeasurements() {
        Learner[] subModels;
        LinkedList<Measurement> measurementList = new LinkedList<Measurement>();
        measurementList.add(new Measurement("model training instances", this.trainingWeightSeenByModel()));
        measurementList.add(new Measurement("model serialized size (bytes)", this.measureByteSize()));
        Measurement[] modelMeasurements = this.getModelMeasurementsImpl();
        if (modelMeasurements != null) {
            measurementList.addAll(Arrays.asList(modelMeasurements));
        }
        if ((subModels = this.getSublearners()) != null && subModels.length > 0) {
            LinkedList<Measurement[]> subMeasurements = new LinkedList<Measurement[]>();
            for (Learner subModel : subModels) {
                if (subModel == null) continue;
                subMeasurements.add(subModel.getModelMeasurements());
            }
            Measurement[] avgMeasurements = Measurement.averageMeasurements((Measurement[][])subMeasurements.toArray((T[])new Measurement[subMeasurements.size()][]));
            measurementList.addAll(Arrays.asList(avgMeasurements));
        }
        return measurementList.toArray(new Measurement[measurementList.size()]);
    }

    @Override
    public void getDescription(StringBuilder out, int indent) {
        StringUtils.appendIndented(out, indent, "Model type: ");
        out.append(this.getClass().getName());
        StringUtils.appendNewline(out);
        Measurement.getMeasurementsDescription(this.getModelMeasurements(), out, indent);
        StringUtils.appendNewlineIndented(out, indent, "Model description:");
        StringUtils.appendNewline(out);
        if (this.trainingHasStarted()) {
            this.getModelDescription(out, indent);
        } else {
            StringUtils.appendIndented(out, indent, "Model has not been trained.");
        }
    }

    @Override
    public Learner[] getSublearners() {
        return this.getSubClassifiers();
    }

    @Override
    public Classifier[] getSubClassifiers() {
        return null;
    }

    @Override
    public Classifier copy() {
        return (Classifier)super.copy();
    }

    @Override
    public MOAObject getModel() {
        return this;
    }

    @Override
    public void trainOnInstance(Example<Instance> example) {
        this.trainOnInstance(example.getData());
    }

    @Override
    public boolean correctlyClassifies(Instance inst) {
        return Utils.maxIndex(this.getVotesForInstance(inst)) == (int)inst.classValue();
    }

    public String getClassNameString() {
        return InstancesHeader.getClassNameString(this.modelContext);
    }

    public String getClassLabelString(int classLabelIndex) {
        return InstancesHeader.getClassLabelString(this.modelContext, classLabelIndex);
    }

    public String getAttributeNameString(int attIndex) {
        return InstancesHeader.getAttributeNameString(this.modelContext, attIndex);
    }

    public String getNominalValueString(int attIndex, int valIndex) {
        return InstancesHeader.getNominalValueString(this.modelContext, attIndex, valIndex);
    }

    public static boolean contextIsCompatible(InstancesHeader originalContext, InstancesHeader newContext) {
        if (newContext.numClasses() < originalContext.numClasses()) {
            return false;
        }
        if (newContext.numAttributes() < originalContext.numAttributes()) {
            return false;
        }
        int oPos = 0;
        int nPos = 0;
        while (oPos < originalContext.numAttributes() && (oPos != originalContext.classIndex() || ++oPos < originalContext.numAttributes())) {
            if (nPos == newContext.classIndex()) {
                ++nPos;
            }
            if (originalContext.attribute(oPos).isNominal()) {
                if (!newContext.attribute(nPos).isNominal()) {
                    return false;
                }
                if (newContext.attribute(nPos).numValues() < originalContext.attribute(oPos).numValues()) {
                    return false;
                }
            } else {
                assert (originalContext.attribute(oPos).isNumeric());
                if (!newContext.attribute(nPos).isNumeric()) {
                    return false;
                }
            }
            ++oPos;
            ++nPos;
        }
        return true;
    }

    @Override
    public AWTRenderer getAWTRenderer() {
        return null;
    }

    public abstract void resetLearningImpl();

    public abstract void trainOnInstanceImpl(Instance var1);

    protected abstract Measurement[] getModelMeasurementsImpl();

    public abstract void getModelDescription(StringBuilder var1, int var2);

    protected static int modelAttIndexToInstanceAttIndex(int index, Instance inst) {
        return inst.classIndex() > index ? index : index + 1;
    }

    protected static int modelAttIndexToInstanceAttIndex(int index, Instances insts) {
        return insts.classIndex() > index ? index : index + 1;
    }
}

