% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSF_Func.R
\name{DSF_Func}
\alias{DSF_Func}
\title{Apply a Function to Transformation to a Data Stream}
\usage{
DSF_Func(dsd = NULL, func, ..., info = FALSE)
}
\arguments{
\item{dsd}{A object of class \link{DSD}.}

\item{func}{a function that takes a data.frame as the first argument and returns the transformed data.frame.}

\item{...}{further arguments are passed on to the function specified in \code{func}.}

\item{info}{logical; does the function also receive and modify the info columns?}
}
\value{
An object of class \code{DSF_Func} (subclass of \link{DSF} and \link{DSD}).
}
\description{
Applies an R function to transform to a data stream.
}
\details{
The function's first argument needs to be a data.frame representing points of the
data stream. The function will be called as \code{ps \%>\% your_function()}, where \code{ps} is the
data.frame with some points obtained using \code{\link[=get_points]{get_points()}} on the data stream source.
}
\examples{
stream <- DSD_Gaussians(k = 3, d = 3)
get_points(stream, n = 5)

## Example 1: rename the columns
rename <- function(x, names) {
  colnames(x) <-  names
  x
}

# By default, the info columns starting with . are not affected.
stream2 <- stream \%>\% DSF_Func(rename, names = c("A", "B", "C"))
stream2
get_points(stream2, n = 5)

## Example 2: add a sum columns
stream3 <- stream2 \%>\% DSF_Func(function(x) {
  x$sum = rowSums(x)
  x
})
stream3
get_points(stream3, n = 5)

## Example 3: Project the stream on its first 2 PCs (using a sample)
pr <- princomp(get_points(stream, n = 100, info = FALSE))
pca_trans <- function(x) predict(pr, x[, c("X1", "X2", "X3")])[, 1:2 , drop = FALSE]
pca_trans(get_points(stream, n = 3, info = FALSE))

stream4 <- stream \%>\% DSF_Func(pca_trans)
stream4

get_points(stream4, n = 3)
plot(stream4)

## Example 4: Change a class labels using info = TRUE. We redefine class 3 as noise (NA)
stream5 <- stream \%>\% DSF_Func(
  function(x) { x[['.class']][x[['.class']] == 3] <- NA; x },
  info = TRUE)
stream5

get_points(stream5, n = 5)
plot(stream5)
}
\seealso{
Other DSF: 
\code{\link{DSF_Convolve}()},
\code{\link{DSF_Downsample}()},
\code{\link{DSF_ExponentialMA}()},
\code{\link{DSF_Scale}()},
\code{\link{DSF_dplyr}()},
\code{\link{DSF}()}
}
\author{
Michael Hahsler
}
\concept{DSF}
