% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSC_BIRCH.R
\name{DSC_BIRCH}
\alias{DSC_BIRCH}
\alias{BIRCH}
\alias{birch}
\title{Balanced Iterative Reducing Clustering using Hierarchies}
\usage{
DSC_BIRCH(
  formula = NULL,
  threshold,
  branching,
  maxLeaf,
  maxMem = 0,
  outlierThreshold = 0.25
)
}
\arguments{
\item{formula}{\code{NULL} to use all features in the stream or a model \link{formula} of the form \code{~ X1 + X2}
to specify the features used for clustering. Only \code{.}, \code{+} and \code{-} are currently
supported in the formula.}

\item{threshold}{threshold used to check whether a new data point can be
absorbed or not.}

\item{branching}{branching factor (maximum amount of child nodes for a
non-leaf node) of the CF-Tree.}

\item{maxLeaf}{maximum number of entries within a leaf node}

\item{maxMem}{memory limitation for the whole CFTree in bytes. Default is 0,
indicating no memory restriction.}

\item{outlierThreshold}{threshold for identifying outliers when rebuilding
the CF-Tree.}
}
\description{
Micro Clusterer.
BIRCH builds a balanced tree of Clustering Features (CFs) to summarize the
stream.
}
\details{
A CF in the calanced tree is a tuple (n, LS, SS) which represents a cluster
by storing the number of elements (n), their linear sum (LS) and their
squared sum (SS). Each new observation descends the tree by following its
closest CF until a leaf node is reached. It is either merged into its
closest leaf-CF or inserted as a new one. All leaf-CFs form the
micro-clusters. Rebuilding the tree is realized by inserting all leaf-CF
nodes into a new tree structure with an increased threshold.
}
\examples{
stream <- DSD_Gaussians(k = 3, d = 2)

BIRCH <- DSC_BIRCH(threshold = .1, branching = 8, maxLeaf = 20)
update(BIRCH, stream, n = 500)
BIRCH

plot(BIRCH, stream)
}
\references{
Zhang T, Ramakrishnan R and Livny M (1996), "BIRCH: An Efficient
Data Clustering Method for Very Large Databases", \emph{In Proceedings of
the 1996 ACM SIGMOD International Conference on Management of Data.}
Montreal, Quebec, Canada , pp. 103-114. ACM.

Zhang T, Ramakrishnan R and Livny M (1997), "BIRCH: A new data clustering
algorithm and its applications", \emph{Data Mining and Knowledge Discovery.}
Vol. 1(2), pp. 141-182.
}
\seealso{
Other DSC_Micro: 
\code{\link{DSC_BICO}()},
\code{\link{DSC_DBSTREAM}()},
\code{\link{DSC_DStream}()},
\code{\link{DSC_Micro}()},
\code{\link{DSC_Sample}()},
\code{\link{DSC_Window}()},
\code{\link{DSC_evoStream}()}
}
\author{
Dennis Assenmacher (\email{Dennis.Assenmacher@uni-muenster.de}),
Matthias Carnein (\email{Matthias.Carnein@uni-muenster.de})
}
\concept{DSC_Micro}
