% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSF_Scale.R
\name{DSF_Scale}
\alias{DSF_Scale}
\alias{DSD_ScaleStream}
\title{Scale a Data Stream}
\usage{
DSF_Scale(dsd, dim = NULL, center = TRUE, scale = TRUE, n = 100)

DSD_ScaleStream(dsd, dim = NULL, center = TRUE, scale = TRUE, n = 100)
}
\arguments{
\item{dsd}{A object of class \link{DSD} that will be scaled.}

\item{dim}{integer vector or names of dimensions that should be scaled? Default is all.}

\item{center, scale}{logical or a numeric vector of length equal to the
number of columns (selected with dim) used for centering/scaling (see function \link{scale}).}

\item{n}{The number of points used by \code{scale_stream()} to creating the centering/scaling}
}
\value{
An object of class \code{DSF_Scale} (subclass of \link{DSF} and \link{DSD}).
}
\description{
Make an unscaled data stream into a scaled data stream.
}
\details{
If \code{center} and \code{scale} are not vectors with scaling factors, then \code{scale_stream()}
estimates the values for centering and scaling (see
\link{scale} in \pkg{base}) using \code{n} points from the stream and the stream is reset if \code{reset = TRUE} and the
\link{DSD} object supports resetting.
}
\section{Deprecated}{

\code{DSD_ScaleStream} is deprecated. Use \code{DSF_Scale} instead.
}

\examples{
stream <- DSD_Gaussians(k = 3, d = 2)

# scale with manually calculated scaling factors
points <- get_points(stream, n = 100, info = FALSE)
center <- colMeans(points)
scale <- apply(points, MARGIN = 2, sd)

scaledStream <- stream \%>\%  DSF_Scale(center = center, scale = scale)
colMeans(get_points(scaledStream, n = 100, info = FALSE))
apply(get_points(scaledStream, n = 100, info = FALSE), MARGIN = 2, sd)

# let DSF_Scale calculate the scaling factors
scaledStream <- stream \%>\% DSF_Scale(n = 100)
colMeans(get_points(scaledStream, n = 100, info = FALSE))
apply(get_points(scaledStream, n = 100, info = FALSE), MARGIN = 2, sd)

## scale only X2
scaledStream <- stream \%>\% DSF_Scale(n = 100, dim = "X2")
colMeans(get_points(scaledStream, n = 100, info = FALSE))
apply(get_points(scaledStream, n = 100, info = FALSE), MARGIN = 2, sd)
}
\seealso{
\link{scale} in \pkg{base}

Other DST: 
\code{\link{DSAggregate}()},
\code{\link{DSClassifier}()},
\code{\link{DSC}()},
\code{\link{DSOutlier}()},
\code{\link{DST_Runner}()},
\code{\link{DST_WriteStream}()},
\code{\link{DST}()},
\code{\link{evaluate}},
\code{\link{predict}()},
\code{\link{update}()}
}
\author{
Michael Hahsler
}
\concept{DST}
