% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{h_get_which_violated}
\alias{h_get_which_violated}
\title{Get Proper Version of \code{which_violated} Function.}
\usage{
h_get_which_violated(geq = TRUE)
}
\arguments{
\item{geq}{(\code{flag}) \cr if \code{TRUE}, then "greater or equal" condition is set.
Otherwise, "less then or equal" is set.}
}
\value{
2-arguments function that checks whether its first argument exceeds
the second one. Both arguments must be numeric.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Internal function that prepares a simple 2-arguments wrapper of
\code{\link[base:which]{base::which()}} that checks whether its first argument exceeds the second
one. Both arguments are numeric. This excess is hard coded in the returned
wrapper function and it is defined either as \eqn{>=} ("greater or equal")
or \eqn{<=} ("lower or equal"), depending on the value of the \code{geq} flag.
}
\examples{
which_violated <- stratallo:::h_get_which_violated()
which_violated(1:3, 3:1)

which_violated <- stratallo:::h_get_which_violated(geq = FALSE)
which_violated(1:3, 3:1)
}
\seealso{
\code{\link[=rna_one_sided]{rna_one_sided()}}.
}
