% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixedDifferences.R
\name{fixedDifferences}
\alias{fixedDifferences}
\title{Fixed Differences}
\usage{
fixedDifferences(
  g,
  count.indels = TRUE,
  consec.indels.as.one = TRUE,
  bases = c("a", "c", "g", "t", "-")
)
}
\arguments{
\item{g}{a \linkS4class{gtypes} object.}

\item{count.indels}{logical. Count indels when evaluating sites for fixed
differences?}

\item{consec.indels.as.one}{logical. If \code{count.indels} is TRUE, count
consecutive indels as a a single indel?}

\item{bases}{a character vector of valid bases to consider.}
}
\value{
a list with components: \describe{ \item{sites}{list of sites with
  fixed differences for each pair of strata} \item{num.fixed}{data.frame of
  number of sites fixed between each pair of strata} }
}
\description{
Summarize fixed base pair differences between strata.
}
\examples{
data(dloop.g)
fd <- fixedDifferences(dloop.g)
fd

}
\seealso{
\code{\link{fixedSites}}, \code{\link{variableSites}}
}
\author{
Eric Archer <eric.archer@noaa.gov>
}
