% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arlequin.R
\name{arlequin}
\alias{arlequin}
\alias{read.arlequin}
\alias{write.arlequin}
\title{Read and Write Arlequin Files}
\usage{
read.arlequin(file)

write.arlequin(g, file = "gtypes.prj", title = "gtypes from R",
  data.type = c("DNA", "MICROSAT", "RFLP"), locus = 1)
}
\arguments{
\item{file}{filename for output file.}

\item{g}{a \linkS4class{gtypes} object.}

\item{title}{title for data in file.}

\item{data.type}{type of data. Can be "DNA", "RFLP", or "MICROSAT".}

\item{locus}{numeric or character designation of which locus to write.}
}
\description{
Read and write an Arlequin-formatted files.
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
\references{
Excoffier, L.G. Laval, and S. Schneider (2005) 
  Arlequin ver. 3.0: An integrated software package for population genetics 
  data analysis. Evolutionary Bioinformatics Online 1:47-50.\cr
  Available at \url{http://cmpg.unibe.ch/software/arlequin3/}
}

