% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/jmodeltest.run.R
\name{jmodeltest.run}
\alias{jmodeltest.run}
\title{jModelTest}
\usage{
jmodeltest.run(x, sub.schemes = 3, unequal.base.freq = FALSE,
  prop.inv.sites = FALSE, rate.var = NULL, AIC = FALSE, AICc = FALSE,
  BIC = FALSE, DT = FALSE, param.imp = FALSE, model.average = FALSE,
  numThreads = 1, path = ifelse(.Platform$OS.type == "windows",
  "C:/Program Files/jModelTest", "/usr/local/bin/jmodeltest"),
  java.opts = NULL)
}
\arguments{
\item{x}{a list of DNA sequences.}

\item{sub.schemes}{number of substitution schemes to test. Can be one of 3, 5, 7, 11, or 203.}

\item{unequal.base.freq}{logical. Include models with unequal base frequencies?}

\item{prop.inv.sites}{logical. Include models with a proportion of invariable sites?}

\item{rate.var}{number of categories for models with rate variation among sites.}

\item{AIC,AICc,BIC,DT}{logical. Calculate respective information criterion metrics?}

\item{param.imp}{logical. Calculate parameter importances?}

\item{model.average}{logical. Do model averaging and parameter importances?}

\item{numThreads}{Number of threads to use.}

\item{path}{path where \code{jModelTest.jar} is located.}

\item{java.opts}{options to \code{java} command line.}
}
\description{
Run jModelTest to determine appropriate substitution model.
}
\details{
Requires that jModelTest is properly installed on the system in \code{path}.
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
\references{
Darriba D, Taboada GL, Doallo R, Posada D. 2012. jModelTest 2: more models,
  new heuristics and parallel computing. Nature Methods 9(8), 772.\cr
  Guindon S and Gascuel O (2003). A simple, fast and accurate method to estimate large
  phylogenies by maximum-likelihood". Systematic Biology 52: 696-704.\cr
  Software available at: \url{https://code.google.com/p/jmodeltest2/}
}

