% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linefuns.R
\name{angle_diff}
\alias{angle_diff}
\title{Calculate the angular difference between lines and a predefined bearing}
\usage{
angle_diff(l, angle, bidirectional = FALSE, absolute = TRUE)
}
\arguments{
\item{l}{A spatial lines object}

\item{angle}{an angle in degrees relative to North, with 90 being East and -90 being West.
(direction of rotation is ignored).}

\item{bidirectional}{Should the result be returned in a bidirectional format?
Default is FALSE. If TRUE, the same line in the oposite direction would have the same bearing}

\item{absolute}{If TRUE (the default) only positive values can be returned}
}
\description{
This function was designed to find lines that are close to parallel and perpendicular
to some pre-defined route. It can return results that are absolute (contain information
on the direction of turn, i.e. + or - values for clockwise/anticlockwise),
bidirectional (which mean values greater than +/- 90 are impossible).
}
\details{
Building on the convention used in \code{\link[=bearing]{bearing()}} and in many applications,
North is definied as 0, East as 90 and West as -90.
}
\examples{
lib_versions <- sf::sf_extSoftVersion()
lib_versions
# fails on some systems (with early versions of PROJ)
if (lib_versions[3] >= "6.3.1") {
  # Find all routes going North-South
  lines_sf <- od2line(od_data_sample, zones = zones_sf)
  angle_diff(lines_sf[2, ], angle = 0)
  angle_diff(lines_sf[2:3, ], angle = 0)
  a <- angle_diff(flowlines, angle = 0, bidirectional = TRUE, absolute = TRUE)
  plot(flowlines)
  plot(flowlines[a < 15, ], add = TRUE, lwd = 3, col = "red")
  # East-West
  plot(flowlines[a > 75, ], add = TRUE, lwd = 3, col = "green")
}
}
\seealso{
Other lines: 
\code{\link{geo_toptail}()},
\code{\link{is_linepoint}()},
\code{\link{line2df}()},
\code{\link{line2points}()},
\code{\link{line_bearing}()},
\code{\link{line_breakup}()},
\code{\link{line_midpoint}()},
\code{\link{line_sample}()},
\code{\link{line_segment}()},
\code{\link{line_via}()},
\code{\link{mats2line}()},
\code{\link{n_sample_length}()},
\code{\link{n_vertices}()},
\code{\link{onewaygeo}()},
\code{\link{points2line}()},
\code{\link{toptail_buff}()},
\code{\link{toptailgs}()},
\code{\link{update_line_geometry}()}
}
\concept{lines}
