% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slope.R
\name{route_slope_matrix}
\alias{route_slope_matrix}
\title{Calculate the gradient of line segments from a matrix of coordinates}
\usage{
route_slope_matrix(m, e = m[, 3], lonlat = TRUE)
}
\arguments{
\item{m}{Matrix containing coordinates and elevations}

\item{e}{Elevations in same units as x (assumed to be metres)}

\item{lonlat}{Are the coordinates in lon/lat order? \code{TRUE} by default}
}
\description{
Calculate the gradient of line segments from a matrix of coordinates
}
\examples{
x = c(0, 2, 3, 4, 5, 9)
y = c(0, 0, 0, 0, 0, 9)
z = c(1, 2, 2, 4, 3, 1) / 10
m = cbind(x, y, z)
plot(x, z, ylim = c(-0.5, 0.5), type = "l")
(gx = route_slope_vector(x, z))
(gxy = route_slope_matrix(m, lonlat = FALSE))
abline(h = 0, lty = 2)
points(x[-length(x)], gx, col = "red")
points(x[-length(x)], gxy, col = "blue")
title("Distance (in x coordinates) elevation profile",
  sub = "Points show calculated gradients of subsequent lines")
}
\seealso{
Other route_funs: 
\code{\link{route_average_gradient}()},
\code{\link{route_rolling_average}()},
\code{\link{route_rolling_diff}()},
\code{\link{route_rolling_gradient}()},
\code{\link{route_sequential_dist}()},
\code{\link{route_slope_vector}()}
}
\concept{route_funs}
