% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/line_via.R
\name{line_via}
\alias{line_via}
\title{Add geometry columns representing a route via intermediary points}
\usage{
line_via(l, p)
}
\arguments{
\item{l}{A spatial lines object}

\item{p}{A spatial points object}
}
\description{
Takes an origin (A) and destination (B), represented by the linestring \code{l},
and generates 3 extra geometries based on points \code{p}:
}
\details{
\enumerate{
\item From A to P1 (P1 being the nearest point to A)
\item From P1 to P2 (P2 being the nearest point to B)
\item From P2 to B
}
}
\examples{
l <- flowlines_sf[2:4, ]
p <- destinations_sf
lv <- line_via(l, p)
# library(mapview)
# mapview(lv) +
#    mapview(lv$leg_orig, col = "red")
library(sf)
plot(lv[3], lwd = 9, reset = FALSE)
plot(lv$leg_orig, col = "red", lwd = 5, add = TRUE)
plot(lv$leg_via, col = "black", add = TRUE)
plot(lv$leg_dest, col = "green", lwd = 5, add = TRUE)
}
\seealso{
Other lines: 
\code{\link{angle_diff}()},
\code{\link{geo_toptail}()},
\code{\link{is_linepoint}()},
\code{\link{line2df}()},
\code{\link{line2points}()},
\code{\link{line_bearing}()},
\code{\link{line_match}()},
\code{\link{line_midpoint}()},
\code{\link{line_sample}()},
\code{\link{line_segment}()},
\code{\link{mats2line}()},
\code{\link{n_sample_length}()},
\code{\link{n_vertices}()},
\code{\link{onewaygeo}()},
\code{\link{points2line}()},
\code{\link{toptail_buff}()},
\code{\link{toptailgs}()},
\code{\link{update_line_geometry}()}
}
\concept{lines}
