% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sepstppm.R
\name{sepstppm}
\alias{sepstppm}
\title{Fit a separable spatio-temporal Poisson process model}
\usage{
sepstppm(x, spaceformula, timeformula)
}
\arguments{
\item{x}{A \code{stpm} object}

\item{spaceformula}{A formula for the spatial component. See \link{ppm} for details}

\item{timeformula}{A formula for the temporal component. It fits a log-linear model with the \link{glm} function}
}
\value{
An object of class \code{sepstppm}
}
\description{
Fit a separable spatio-temporal Poisson process model
}
\examples{
crimesub <- stpm(valenciacrimes$df[101:200, ],
           names = colnames(valenciacrimes$df)[-c(1:3)])

mod1 <- sepstppm(crimesub, spaceformula = ~x ,
                  timeformula = ~ day)



}
