% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.locstppm.R
\name{print.locstppm}
\alias{print.locstppm}
\title{Print of a fitted local spatio-temporal Poisson process model}
\usage{
\method{print}{locstppm}(x, ...)
}
\arguments{
\item{x}{An object of class \code{locstppm}}

\item{...}{additional unused argument}
}
\description{
The function prints the main information of the distribution of the parameters
 of a fitted local spatio-temporal Poisson process model.
}
\examples{
\dontrun{
inh <- rstpp(lambda = function(x, y, t, a) {exp(a[1] + a[2]*x)}, 
             par = c(0.005, 5), seed = 2)
inh_local <- locstppm(inh, formula = ~ x)

inh_local

}


}
\references{
D'Angelo, N., Adelfio, G., and Mateu, J. (2023). Locally weighted minimum contrast estimation for spatio-temporal log-Gaussian Cox processes. Computational Statistics & Data Analysis, 180, 107679.
}
\seealso{
\link{locstppm}, \link{summary.locstppm},
\link{plot.locstppm}
}
\author{
Nicoletta D'Angelo
}
